<?php
use Drupal\Core\Render\BubbleableMetadata;

/**
 * Implements hook_token_info().
 */
function registration_extra_token_info() 
{
  $info = [];
  $info['types']['registration_extra'] = [
    'name' => t('Registration extra token'),
    'description' => '',
    'needs-data' => 'registration',
  ];
  $info['tokens']['registration_extra']['registration_data'] = [
    'name' => t('Registration data'),
    'description' => '',
    'type' => 'registration',
  ];
  return $info;
}
/**
* Implements hook_tokens().
*/
function registration_extra_tokens($type, $tokens, array $data, array $options, BubbleableMetadata $bubbleable_metadata) 
{
  $replacements = [];
  if ($type == 'registration_extra' && !empty($data['registration'])) 
  {
    $toolService = \Drupal::service('registration_extra.tool');

    $registration = $data['registration'];
    $hostEntity = $registration->getHostEntity();

    $entityTypeManager = \Drupal::entityTypeManager();
    $settings = $entityTypeManager->getStorage('registration_settings')->loadSettingsForHostEntity($hostEntity);

    foreach ($tokens as $name => $original) {
      switch ($name) {
        case 'registration_data': 
          $replacements[$original] = $toolService->buildDisplay($registration);
        break;
      }
    }
  }
  return $replacements;
}