<?php
namespace Drupal\registration_extra;

use Drupal\Core\Entity\EntityTypeInterface;
use Drupal\Core\Entity\FieldableEntityInterface;
use Symfony\Component\Routing\Route;
use Drupal\Core\Database\Database;
use Drupal\Core\Entity\EntityDisplayRepositoryInterface;
use Drupal\Core\Entity\EntityFieldManager;
use Drupal\Core\Entity\EntityInterface;
use Drupal\Core\Entity\EntityTypeBundleInfo;
use Drupal\Core\Entity\EntityTypeManagerInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Routing\RouteProviderInterface;
use Drupal\Core\Session\AccountProxy;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\registration\Entity\RegistrationInterface;
use Drupal\registration\Entity\RegistrationSettings;
use Drupal\registration\Event\RegistrationDataAlterEvent;
use Drupal\registration\Event\RegistrationEvents;
use Drupal\user\UserInterface;
use Symfony\Component\HttpFoundation\ParameterBag;

/**
 * Defines the class for the registration manager service.
 */
class RegistrationExtraManager extends \Drupal\registration\RegistrationManager 
{
  public function getExtraRoute(EntityTypeInterface $entity_type, string $route_id): ?Route 
  {
    $path = $this->getBasePath($entity_type); 
    if (!$path) {
      return NULL;
    }
    // Build the 'manage' route and adjust for other routes.
    $route = $this->buildManageRoute($entity_type, $path);
    switch ($route_id) {
      case 'download': 
        $route
          ->setPath($route->getPath() . '/download')
          ->setDefaults([
            '_form' => '\Drupal\registration_extra\Form\DownloadRegistrationsForm',
            '_title' => 'Registrations - download',
          ]);
        break;
      default:  
        $route = $this->getRoute($entity_type, $route_id);
    }
    return $route;
  }

  public function getRegistrationField(EntityTypeInterface $entity_type, $bundle = NULL): mixed 
  {
    if ($entity_type->entityClassImplements(FieldableEntityInterface::class)) 
    {
      $entity_type_id = $entity_type->id();
      $bundle_info = $this->entityTypeBundleInfo->getBundleInfo($entity_type_id);
      foreach ($bundle_info as $type => $info) {
        $fields = $this->entityFieldManager->getFieldDefinitions($entity_type_id, $type);
        foreach ($fields as $field) {
          if ($field->getType() == 'registration') {
            if (is_null($bundle) || ($type == $bundle)) { 
              return $field; 
            }
          }
        }
      }
    }
    return FALSE;
  }
}