<?php

namespace Drupal\registration_extra;

use Drupal\Core\Session\AccountProxyInterface;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Drupal\registration\Entity\Registration;

class RegistrationExtraService 
{
  public $currentUser;
  public $session;
  
	public function __construct(AccountProxyInterface $current_user, SessionInterface $session) 
  {
    $this->currentUser = $current_user;
    $this->session = $session;
  }

  public function getLabels(Registration $registration) 
  {
    $labels = [];
    foreach ($message->getFieldDefinitions() as $key => $field) {
      if ($label = $field->getLabel()) {
        // Remove characters not allowed in keys of associative arrays.
        $labels[$key] = filter_var($label, FILTER_UNSAFE_RAW,
          FILTER_FLAG_STRIP_HIGH | FILTER_FLAG_STRIP_LOW | FILTER_FLAG_NO_ENCODE_QUOTES
        );
      }
    }
    return $labels;
  }
}