<?php
namespace Drupal\registration_extra\Routing;

use Drupal\Core\Routing\RouteSubscriberBase;
use Drupal\Core\Routing\RoutingEvents;
use Drupal\registration\RegistrationManagerInterface;
use Symfony\Component\Routing\RouteCollection;

/**
 * Subscriber for Registration routes.
 *
 * @see \Drupal\registration\Plugin\Derivative\RegistrationLocalTask
 */
class RouteSubscriber extends RouteSubscriberBase 
{
  /**
   * The registration manager.
   *
   * @var \Drupal\registration\RegistrationManagerInterface
   */
  protected RegistrationManagerInterface $registrationManager;

  
  protected RegistrationManagerInterface $registrationExtraManager;

  /**
   * Creates a RouteSubscriber object.
   *
   * @param \Drupal\registration\RegistrationManagerInterface $registration_manager
   *   The registration manager.
   */
  public function __construct(RegistrationManagerInterface $registration_manager, RegistrationManagerInterface $registration_extra_manager) 
  {
    $this->registrationManager = $registration_manager;
    $this->registrationExtraManager = $registration_extra_manager;
  }

  /**
   * {@inheritdoc}
   */
  protected function alterRoutes(RouteCollection $collection) 
  {    
    // Add routes for managing registrations and registering.
    foreach ($this->registrationManager->getRegistrationEnabledEntityTypes() as $entity_type_id => $entity_type) {
      if ($route = $this->registrationExtraManager->getExtraRoute($entity_type, 'download')) { //echo $route->getPath();
        $collection->add("entity.$entity_type_id.registration.download", $route);
      }
    }
    //die();
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array 
  {
    $events = parent::getSubscribedEvents();
    $events[RoutingEvents::ALTER] = ['onAlterRoutes'];
    return $events;
  }
}