<?php
namespace Drupal\registration_extra\EventSubscriber;

use Drupal\registration\RegistrationManagerInterface;
use Drupal\registration\Event\RegistrationEvents;
use Drupal\registration\Event\RegistrationDataAlterEvent;
use Drupal\Core\Render\BubbleableMetadata;
use Drupal\Core\Utility\Token;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Provides an event subscriber to set the completed timestamp.
 */
class RegistrationAlterMail implements EventSubscriberInterface 
{
  /**
   * The registration manager.
   *
   * @var \Drupal\registration\RegistrationManagerInterface
   */
  protected RegistrationManagerInterface $registrationManager;
  
  protected Token $tokenService;

  public function __construct(RegistrationManagerInterface $registration_manager, Token $token_service) 
  {
    $this->registrationManager = $registration_manager;
    $this->tokenService = $token_service;
  }

  public function onAlterMail(RegistrationDataAlterEvent $event) 
  {
    $data = $event->getData();
    $context = $event->getContext();
    if($context && isset($context['data'])) 
    {
      $bubbleable_metadata = new BubbleableMetadata();
      $entityTypeManager = \Drupal::entityTypeManager();

      if($context['data']['mail_tag'] == 'reminder') {
        
        $hostEntity = $context['host_entity'];
        $registration = $context['registration'];

        $registrationTypeId = $hostEntity->getEntity()->get('field_event_registration')->registration_type;
        $registrationType = $entityTypeManager->getStorage('registration_type')->load($registrationTypeId);
        $mailSubject = $registrationType->getThirdPartySetting('registration_extra', 'default_template_reminder_subject'); 

        $mailSubject = $this->tokenService->replace($mailSubject, [ 'registration' => $registration, 'node' => $hostEntity->getEntity(), ], [], $bubbleable_metadata);
        $data['subject'] = $mailSubject;

        $event->setData($data);
      }
    }
  }
  
  public static function getSubscribedEvents(): array {    
    return [
      // Static class constant => method on this class.
      RegistrationEvents::REGISTRATION_ALTER_MAIL => ['onAlterMail'],
    ];
  }
}