<?php
namespace Drupal\registration_extra\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\registration\Entity\Registration;
use \Symfony\Component\HttpFoundation\StreamedResponse;
use Drupal\Core\Form\FormBase;
use Drupal\Core\Url;
use Drupal\user\Entity\User;
use Drupal\field\Entity\FieldConfig;
use Drupal\registration\Entity\RegistrationType;

class DownloadRegistrationsForm extends \Drupal\registration\Form\RegistrationFormBase 
{
  public function getFormId() {
    return 'registration_extra_download';
  }

  public function buildForm(array $form, FormStateInterface $form_state, $node = NULL) 
  { 
    $form['actions'] = [
      '#type' => 'actions',
    ];

    // Add a submit button that handles the submission of the form.
    $form['actions']['submit'] = [
      '#type' => 'submit',
      '#value' => $this->t('Download'),
    ];

    return $form;
  }

  public function submitForm(array &$form, FormStateInterface $form_state)
  {
    $database = \Drupal::database();
    $entityTypeManager = \Drupal::service('entity_type.manager');
    $host_entity = $this->getHostEntity($form_state);

    $registrationType = $host_entity->getRegistrationType();

    $results = [];
    $query = $database->select('registration', 'r');
    $query->fields('r', [
      'registration_id',
    ]);
    $query->condition('r.entity_type_id', $host_entity->getEntityTypeId());
    $query->condition('r.entity_id', $host_entity->id());
    
    $results = $query->execute();
    
    $registrationIds = $results->fetchAllKeyed(0,0);
    
    $registrations = Registration::loadMultiple(array_keys($registrationIds));
    
    $fields = [];

    $registrationTypeId = $registrationType->Id();

    $configFactory = \Drupal::configFactory();
    $fieldConfigNames = $configFactory->listAll('field.field.registration.'.$registrationTypeId);
    $fieldsConfig = $configFactory->loadMultiple($fieldConfigNames);
    foreach ($fieldsConfig as $key => $fieldConfig) {
      $fields[$fieldConfig->get('field_name')] = $fieldConfig->get('field_name');
    }

    $registration_storage = \Drupal::entityTypeManager()->getStorage('registration_type');

    $response = new StreamedResponse(function () use ($registrations, $fields, $registration_storage) {
      $handle = fopen('php://output', 'a+');
      $BOM = "\xEF\xBB\xBF"; // UTF-8 BOM
      fwrite($handle, $BOM); // NEW LINE
  
      $columns = [
        'registration_id', 'type', 'entity_id', 'entity_label', 'anon_mail', 'user_uid', 'count', 'mail', 'author_uid', 'state', 'created', 'changed', 'completed'
      ];
      $columns += $fields;
      
      fputcsv($handle, $columns, ';', '"');
  
      foreach ($registrations as $key => $registration) 
      {
        //$registration = $registration_storage->load($record->registration_id);
        $author = $registration->getAuthor();
        $user = $registration->getUser();
        $created = $registration->getCreatedTime();
        $changed = $registration->get('changed')->value;
        //$this->dateFormatter->format($registration->getCreatedTime(), 'short')
        $row = [
          'registration_id' => $registration->Id(),
          'type' => $registration->getType()->Id(),
          'entity_id' => $registration->getHostEntity()->Id(),
          'entity_Label' => $registration->getHostEntity()->Label(),
          'anon_mail' => $registration->getAnonymousEmail(),
          'user_uid' => $user ? $author->Id() : null,
          'count' => $registration-> getSpacesReserved(),
          'mail' => $registration->getEmail(),
          'author_uid' => $author ? $author->Id() : null,
          'state' => $registration->getEmail(),
          'created' => date('d/m/Y', $created),
          'changed' => date('d/m/Y', $changed),
          'completed' => $registration->getEmail(),
        ];
        foreach ($fields as $key => $value) {
          $row[$key] = '';
          if( $registration->hasField($key) ) {
            $fieldData = $registration->get($key);

            if($fieldData->entity)
              $row[$key] = $fieldData->entity->Id().' : '.$fieldData->entity->Label();
            else
              $row[$key] = $fieldData->value;
          }
        }

        if($key == 0) {
          fputcsv($handle, $header, ';', '"');
        }
        fputcsv($handle, $row, ';', '"');  
      }
      
      fclose($handle);
    });

    $requestTime =  \Drupal::time()->getCurrentTime();
    $title = 'registration-'.$host_entity->Id(). '_' . $requestTime;
    $fileName = $title . '.csv';

    $response->headers->set('Content-Type', 'application/force-download');
    $response->headers->set('Content-Disposition', 'attachment; filename="' . $fileName . '"');
    
    $form_state->setResponse($response);
  }
}