<?php
namespace Drupal\registration_extra\Plugin\Derivative;

use Drupal\Component\Plugin\Derivative\DeriverBase;
use Drupal\Core\Plugin\Discovery\ContainerDeriverInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\registration\RegistrationManagerInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Provides local tasks for entity types with attached registration fields.
 */
class RegistrationExtraLocalTask extends DeriverBase implements ContainerDeriverInterface 
{
  use StringTranslationTrait;

  /**
   * The registration manager.
   *
   * @var \Drupal\registration\RegistrationManagerInterface
   */
  protected RegistrationManagerInterface $registrationManager;
  
  protected RegistrationManagerInterface $registrationExtraManager;

  /**
   * Creates a RegistrationLocalTask object.
   *
   * @param \Drupal\registration\RegistrationManagerInterface $registration_manager
   *   The registration manager.
   */
  public function __construct(RegistrationManagerInterface $registration_manager, RegistrationManagerInterface $registration_extra_manager) 
  {
    $this->registrationManager = $registration_manager;
    $this->registrationExtraManager = $registration_extra_manager;
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, $base_plugin_id): RegistrationExtraLocalTask 
  {
    return new static(
      $container->get('registration.manager'),
      $container->get('registration_extra.manager')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function getDerivativeDefinitions($base_plugin_definition): array 
  {
    $this->derivatives = [];

    foreach ($this->registrationManager->getRegistrationEnabledEntityTypes() as $entity_type_id => $entity_type) { 
    //echo $entity_type_id .' => '.$entity_type->Id().'<br>';
      if ($this->registrationExtraManager->getExtraRoute($entity_type, 'download')) {
        $this->derivatives["$entity_type_id.registration.download"] = [
          'route_name' => "entity.$entity_type_id.registration.download",
          'title' => $this->t('Download'),
          'parent_id' => "registration.entities:$entity_type_id.registration.manage_registrations",
          'weight' => 20,
        ];
      }
    }
    
    foreach ($this->derivatives as &$entry) {
      $entry += $base_plugin_definition;
    }
    
    return $this->derivatives;
  }
}