<?php

namespace Drupal\registration_extra;

use Drupal\Core\Session\AccountProxyInterface;
use Drupal\mysql\Driver\Database\mysql\Connection;
use Symfony\Component\HttpFoundation\Session\SessionInterface;
use Drupal\registration\Entity\Registration;
use Drupal\Core\Render\Markup;

class ToolService 
{

	public function __construct()
  {
  }
  

  public function buildDisplay(Registration $registration)
  {
    $entityTypeManager = \Drupal::entityTypeManager();
    $configFactory = \Drupal::configFactory();

    $registrationType = $registration->getType();
    $registrationTypeId = $registrationType->Id();

    $hostEntity = $registration->getHostEntity();
    $langcode = $registration->getLangcode();
    if(!$langcode)
      $langcode = \Drupal::languageManager()->getDefaultLanguage()->getId();
    
    $registrationSettings = $entityTypeManager->getStorage('registration_settings')->loadSettingsForHostEntity($hostEntity, $langcode);

    $fields = [];
    $fieldConfigNames = $configFactory->listAll('field.field.registration.'.$registrationTypeId);
    $fieldsConfig = $configFactory->loadMultiple($fieldConfigNames);
    foreach ($fieldsConfig as $key => $fieldConfig) {
      $fields[$fieldConfig->get('field_name')] = $fieldConfig->get('label');
    }

    $author = $registration->getAuthor();
    $user = $registration->getUser();
    $created = $registration->getCreatedTime();
    $changed = $registration->get('changed')->value;

    $html = '';
    $html .= '<div>Id: '.$registration->Id().' </div>';
    $html .= '<div>Contenu: '.$registration->getHostEntity()->Label() . ' ('. $registration->getHostEntity()->Id().') </div>';
    $html .= '<div>Email: '.($user ? $registration->getEmail() : $registration->getAnonymousEmail()).' </div>';
    if($user)
      $html .= '<div>Utilisateur: '.$user->Id().' -  '.$user->getDisplayname().' </div>';
    $html .= '<div>Créé le: '.date('d/m/Y', $created).' </div>';

    foreach ($fields as $key => $value) {
      if( $registration->hasField($key)){
        $fieldData = $registration->get($key);
        if($fieldData->entity)
        $html .= '<div>'.$value.': '.$fieldData->entity->Label().' ('.$fieldData->entity->Id().') </div>';
        else
        $html .= '<div>'.$value.':'.$fieldData->value.' </div>';
      }
    }
    return Markup::create($html);
  }  
}