# Related Content

Provides a configurable block that displays content related to the current node based on taxonomy terms, profile references, and optionally, the node owner.

## Features

- Displays related nodes in a "load more" style block.
- Configurable view mode and layout (one or two columns).
- Limit items per page and maximum number of pages loaded.
- Filter by taxonomy fields, profile reference fields, and content owner.
- Admin settings form to control behavior.

## Requirements

- Drupal 10.
- Works with standard node types and reference fields.

## Installation

1. Download and enable the module:

```bash
composer require drupal/related_content
drush en related_content
```
2. Go to the configuration page at:

/admin/config/content/related-content

3. Choose the content type, view mode, and reference fields.

## Configuration

Go to Configuration → Content → Related Content Settings.

Select:

- The content type to relate from.
- View mode for rendering items.
- Taxonomy and profile reference fields.
- Display mode (1 or 2 columns).
- Items per page and max pages.

## Usage

- The block "Related content" will be available at /admin/structure/block.
- Place it in a region of your theme.
- It will display content related to the current node context.

## Maintainers

Current maintainers for Drupal 10:

Víctor Barón (vbaron)- https://www.drupal.org/u/vbaron
