(function (Drupal, drupalSettings, once) {
  Drupal.behaviors.LoadMore = {
    attach: function (context) {
      // Use once to ensure the event listener is attached only once.
      once('load-more-button', '.load-more', context).forEach((button) => {
        button.addEventListener("click", async() => {
          const spinner = button.querySelector(".spinner");
          const buttonText = button.querySelector(".button-text");

          // Show spinner and disable button
          if (spinner) {
            spinner.classList.remove("d-none");
          }
          
          button.disabled = true;

          const page = parseInt(button.dataset.page);
          const settings = drupalSettings.RelatedContent;

          if (page >= settings.max_pages) {
            button.remove();
            return;
          }

          const params = new URLSearchParams({
            nid: settings.nid,
            uid: settings.uid,
            limit: settings.limit,
            page: page,
          });

          if (Array.isArray(settings.tids)) {
            settings.tids.forEach((tid) => params.append("tids[]", tid));
          }

          if (Array.isArray(settings.author_profile_ids)) {
            settings.author_profile_ids.forEach((aid) =>
              params.append("author_profile_ids[]", aid)
            );
          }

          try {
            const response = await fetch(`/related-content/load-more?${params.toString()}`);
            const data = await response.json();

            if (data.content) {
              const container = document.querySelector(".related-items");
              const tempDiv = document.createElement("div");
              tempDiv.innerHTML = data.content;

              // Injected the new HTML received.
              [...tempDiv.children].forEach((child) => {
                container.appendChild(child);
              });

              button.dataset.page = page + 1;

              if (!data.hasMore) {
                button.remove();
              }
            } else {
              button.remove();
            }
          } catch (e) {
          } finally {
            spinner.classList.add("d-none");
            button.disabled = false;
          }
        });
      });
    },
  };
})(Drupal, drupalSettings, once);
