# Renderable options

The renderable_options modules is a module that allows you to render elements in
radio/checkbox elements instead of only labels.

For a full description of the module, visit the
[project page](http://drupal.org/project/renderable_options).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](http://drupal.org/project/issues/renderable_options)


## Table of contents

- Requirements
- Installation
- Configuration
- Create field groups
- Maintainers


## Requirements

This module requires [Better Exposed Filters](https://www.drupal.org/project/better_exposed_filters)
to allow full features.

This module use the new Entity Reference Views filter.
See [change record](https://www.drupal.org/node/3403710).
BUT at the moment, entity reference filters is not defined by default. See
change record to know how to define filter for your fields thanks to
hook_views_data_alter hook.
Otherwise, for standard filters, you can use [Views Core Entity Reference module](https://www.drupal.org/project/views_core_entity_reference).


## Installation

Install as you would normally install a contributed Drupal module. For further
information, see
[Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).


## Configuration

1. Install [Better Exposed Filters](https://www.drupal.org/project/better_exposed_filters)
1. module.
1. Use [Views Core Entity Reference](https://www.drupal.org/project/views_core_entity_reference)
   module or define filters you want to override thanks to
   hook_views_data_alter.
1. Now editing a filter, choose "Entity view" as Reference method.
1. Select bundles to filter on.
1. Choose "Select list" as Select type.
1. In BEF settings, for your filter, select "Checkboxes/Radio Buttons with
   renderable Labels" in Exposed filter widget select list.
1. Select the View mode in the select list.
1. Configure the view mode in your entity view mode UI.

## Maintainers

- Fabien Clément - [goz](http://drupal.org/u/goz)
