<?php

namespace Drupal\renderable_options\Plugin\better_exposed_filters\filter;

use Drupal\better_exposed_filters\Plugin\better_exposed_filters\filter\RadioButtons;
use Drupal\Core\Entity\EntityDisplayRepositoryInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\ContainerFactoryPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Renderable radio buttons widget implementation.
 *
 * @BetterExposedFiltersFilterWidget(
 *   id = "renderable_radio_buttons",
 *   label = @Translation("Checkboxes/Radio Buttons with renderable Labels"),
 * )
 */
class RenderableRadioButtons extends RadioButtons implements ContainerFactoryPluginInterface {

  /**
   * {@inheritdoc}
   */
  public function __construct(array $configuration, $plugin_id, $plugin_definition, protected EntityDisplayRepositoryInterface $entityDisplayRepository) {
    parent::__construct($configuration, $plugin_id, $plugin_definition);
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
      $configuration,
      $plugin_id,
      $plugin_definition,
      $container->get('entity_display.repository')
    );
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration(): array {
    return parent::defaultConfiguration() + [
      'view_mode' => 'default',
    ];
  }

  /**
   * {@inheritdoc}
   */
  public static function isApplicable(mixed $filter = NULL, array $filter_options = []): bool {
    /** @var \Drupal\views\Plugin\views\filter\FilterPluginBase $filter */
    $is_applicable = parent::isApplicable($filter, $filter_options);

    if (is_a($filter, 'Drupal\views\Plugin\views\filter\EntityReference')) {
      // Autocomplete and dropdown filter are both instances of EntityReference,
      // but we can't show BEF options for the autocomplete widget.
      if ($filter_options['type'] === 'select' || $filter_options['widget'] === 'select') {
        $is_applicable = TRUE;
      }
    }

    return $is_applicable;
  }

  /**
   * {@inheritdoc}
   */
  public function buildConfigurationForm(array $form, FormStateInterface $form_state): array {
    /** @var \Drupal\views\Plugin\views\filter\FilterPluginBase $filter */
    $filter = $this->handler;

    $form = parent::buildConfigurationForm($form, $form_state);

    if (!str_starts_with($filter->options['sub_handler'], 'entity_view:')) {
      return $form;
    }

    // Get available view modes.
    [, $entity_type] = explode(':', $filter->options['sub_handler']);

    $view_modes = $this->entityDisplayRepository->getViewModes($entity_type);
    $view_modes_options = ['default' => $this->t('Default')];
    foreach ($view_modes as $view_mode) {
      $view_modes_options[$view_mode['id']] = $view_mode['label'];
    }

    $form['view_mode'] = [
      '#type' => 'select',
      '#title' => $this->t('View mode'),
      '#options' => $view_modes_options,
      '#default_value' => $this->configuration['view_mode'] ?? 'default',
    ];

    return $form;
  }

}
