<?php

namespace Drupal\renderable_options\Plugin\EntityReferenceSelection;

use Drupal\Component\Render\FormattableMarkup;
use Drupal\Component\Utility\Html;
use Drupal\renderable_options\Plugin\Derivative\EntityViewSelectionDeriver;
use Drupal\Core\Entity\Attribute\EntityReferenceSelection;
use Drupal\Core\Entity\Plugin\EntityReferenceSelection\DefaultSelection;
use Drupal\Core\StringTranslation\TranslatableMarkup;

/**
 * Default plugin implementation of the Entity Reference Selection plugin.
 *
 * Also serves as a base class for specific types of Entity Reference
 * Selection plugins.
 *
 * @see \Drupal\Core\Entity\EntityReferenceSelection\SelectionPluginManager
 * @see \Drupal\Core\Entity\Annotation\EntityReferenceSelection
 * @see \Drupal\Core\Entity\EntityReferenceSelection\SelectionInterface
 * @see \Drupal\Core\Entity\Plugin\Derivative\EntityViewSelectionDeriver
 * @see plugin_api
 */
#[EntityReferenceSelection(
  id: "entity_view",
  label: new TranslatableMarkup("Entity view"),
  group: "entity_view",
  weight: 0,
  deriver: EntityViewSelectionDeriver::class,
)]
class EntityViewSelection extends DefaultSelection {

  /**
   * Validates a target_bundles element.
   */
  public function getReferenceableEntities($match = NULL, $match_operator = 'CONTAINS', $limit = 0) {
    $target_type = $this->getConfiguration()['target_type'];

    $query = $this->buildEntityQuery($match, $match_operator);
    if ($limit > 0) {
      $query->range(0, $limit);
    }

    $result = $query->execute();

    if (empty($result)) {
      return [];
    }

    $options = [];
    $entities = $this->entityTypeManager->getStorage($target_type)->loadMultiple($result);
    $viewBuilder = $this->entityTypeManager->getViewBuilder($target_type);
    foreach ($entities as $entity_id => $entity) {
      $bundle = $entity->bundle();
      $build = $viewBuilder->view($entity, 'default');
      $option = new \stdClass();
      $option->option = new FormattableMarkup(Html::escape($this->entityRepository->getTranslationFromContext($entity)->label() ?? ''), []);
      $option->renderable = $build;
      $options[$bundle][$entity_id] = $option;
    }

    return $options;
  }

}
