<?php

namespace Drupal\rendered_entity_list_formatter\Hook;

use Drupal\Core\StringTranslation\StringTranslationTrait;
use Drupal\Core\Hook\Attribute\Hook;
use Drupal\Core\Routing\RouteMatchInterface;

/**
 * Hook implementations for rendered_entity_list_formatter.
 */
class RenderedEntityListFormatterHooks {
  use StringTranslationTrait;

  /**
   * Implements hook_help().
   */
  #[Hook('help')]
  public function help($route_name, RouteMatchInterface $route_match) {
    switch ($route_name) {
      case 'help.page.rendered_entity_list_formatter':
        $output = '';
        $output .= '<h3>' . $this->t('About') . '</h3>';
        $output .= '<p>' . $this->t('This module provides a custom field formatter that extends the rendered entity field formatter display. It allows the list of referenced entities to be displayed as an unordered list in order to comply to accessibility requirements') . '</p>';
        return $output;
    }
  }

}
