<?php

namespace Drupal\rendered_entity_list_formatter\Hook;

use Drupal\Core\Hook\Attribute\Hook;

/**
 * Hook implementations for rendered_entity_list_formatter.
 */
class RenderedEntityListFormatterThemeHooks {
  /* ************************************************************************** */
  // Theme hooks.
  /* ************************************************************************** */

  /**
   * Implements hook_theme().
   */
  #[Hook('theme')]
  public function theme() {
    return [
      'rendered_entity_list' => [
        'variables' => [
          'items' => [],
          'default_tag' => 'ul',
        ],
      ],
      'rendered_entity_list_item' => [
        'variables' => [
          'content' => NULL,
          'entity' => NULL,
          'default_tag' => 'li',
        ],
      ],
    ];
  }

}
