<?php

namespace Drupal\replicate_actions\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Security\TrustedCallbackInterface;
use Drupal\Core\StringTranslation\StringTranslationTrait;

/**
 * Form alter class for the replicate confirm form.
 */
class ReplicateFormAlter implements TrustedCallbackInterface {

  use StringTranslationTrait;

  /**
   * Alter the replicate confirm form.
   */
  public function alterForm(&$form, FormStateInterface $form_state): void {
    $form['actions']['submit']['#submit'][] = [
      self::class, 'submitRedirect',
    ];
  }

  /**
   * Set a redirect to the replicated entity's edit form.
   *
   * @param array $form
   *   An associative array containing the structure of the form.
   * @param \Drupal\Core\Form\FormStateInterface $form_state
   *   The current state of the form.
   */
  public static function submitRedirect(array &$form, FormStateInterface $form_state): void {
    /** @var \Drupal\Core\Entity\ContentEntityBase $replicated_entity */
    $replicated_entity = $form_state->get('replicated_entity');

    if (!$replicated_entity->hasLinkTemplate('edit-form')) {
      return;
    }

    // Redirect to the edit form.
    $form_state->setRedirect($replicated_entity->toUrl('edit-form')
      ->getRouteName(), [
      $replicated_entity->getEntityTypeId() => $replicated_entity->id(),
    ]);
  }

  /**
   * {@inheritdoc}
   */
  public static function trustedCallbacks(): array {
    return ['submitRedirect'];
  }

}
