# Request Logger

Logs every HTTP request to the website with response details sent to the
standard logger, including responses returned directly from cache. It acts as an
Apache/Nginx access.log, but stores more useful metadata about the request
(timestamp in milliseconds, separate path, query string, headers, attributes)
and the response (response generation duration in milliseconds, size, memory
usage, cache hit/miss, headers, etc).

This data is useful for monitoring site performance, tracking cache hit rates,
and building other analytics reports.

For debugging, you can temporarily enable logging of full HTTP headers and add
other custom fields.

## Usage=

Just install the module and it works out of the box, adding a new log entry for
each request to the website.

On the settings page `/admin/config/development/request_logger` (Home »
Administration » Configuration » Development » Request Logger) you can choose
exactly which data to store in the logs.

Using this module, you can completely disable the Apache/Nginx access.log
because the same information can be logged via the Logger module with richer
details and saved to the same access.log file, just like Apache/Nginx.

There is also a submodule **Request Logger Reports** that provides viewing logs
directly in the Drupal Admin Panel with the ability to aggregate, filter and
sort logs by any custom field (eg, sort requests by duration or memory usage),
and to build custom metrics, reports, and charts.

## Extended structured logs

By default, this module works well with the default Drupal loggers (DBLog and
Syslog) and stores basic request and response details in the log message string.

To store more details about the request and response, install the
[Logger](https://www.drupal.org/project/logger) module — it will extend log
entries with structured data, allowing you to build custom reports and charts by
any custom field from the log entry (for example, average response time or
memory usage per request, or regexp matches).

The [Logger DB](https://www.drupal.org/project/logger_db) module provides
viewing logs directly in the Drupal Admin Panel with the ability to aggregate,
filter and sort logs by any custom field (eg, sort requests by duration or
memory usage), and to build metrics, reports, and charts.

A submodule "Request Logger Reports" provides displaying logged requests and
responses directly in the Drupal Admin Panel with the ability to filter by any
custom field using the [Logger DB](https://www.drupal.org/project/logger_db)
module, and even build useful charts with the help of the
[Charts](https://www.drupal.org/project/charts) module.

## Log entry example
```json
{
  "timestamp_float": 1759500536.654993,
  "message": "GET /node - query: page=2&user=3, response: duration: 0.227 sec, memory: 3.518 MB, page cache: HIT",
  "channel": "request_logger",
  "severity": 6,
  "uid": 0,
  "metadata": {
    "request": {
      "method": "GET",
      "path": "/mode",
      "query": "page=2&user=3",
      "uuid": "a5e06180-6348-4dcd-920f-91386a34dc21"
    },
    "response": {
      "code": 200,
      "size": 42749,
      "duration": 0.227,
      "memory_usage": 3688552,
      "memory_usage_peak": 5021640,
      "page_cache": "HIT"
    }
  }
}
```
