<?php

declare(strict_types=1);

namespace Drupal\request_logger_test\Controller;

use Drupal\Core\Controller\ControllerBase;

/**
 * Controller for the request_logger_reports_test test page.
 */
class TestPageController extends ControllerBase {

  /**
   * A cacheable page.
   */
  public function pageCacheable() {
    return [
      'markup' => [
        '#markup' => 'A cacheable page',
      ],
    ];
  }

  /**
   * An uncacheable page.
   */
  public function pageUncacheable() {
    return [
      'markup' => [
        '#markup' => 'An uncacheable page',
      ],
      '#cache' => [
        'max-age' => 0,
      ],
    ];
  }

}
