<?php

namespace Drupal\require_login\Form;

use Drupal\Core\Form\ConfigFormBase;
use Drupal\Core\Form\FormStateInterface;

/**
 * Configure Require Login settings for this site.
 */
class RequireLoginSettingsForm extends ConfigFormBase {

  /**
   * {@inheritdoc}
   */
  public function getFormId() {
    return 'require_login_settings_form';
  }

  /**
   * {@inheritdoc}
   */
  protected function getEditableConfigNames() {
    return ['require_login.config'];
  }

  /**
   * {@inheritdoc}
   */
  public function buildForm(array $form, FormStateInterface $form_state) {
    $config = $this->config('require_login.config');
    $form['require_login_deny_message'] = array(
      '#type' => 'textarea',
      '#title' => t('Deny Message'),
      '#description' => t('Message shown to non-authenticated visitors after login page redirect.'),
      '#default_value' => $config->get('deny_message'),
    );
    $form['require_login_excluded_paths'] = array(
      '#type' => 'textarea',
      '#title' => t('Exclude Paths'),
      '#description' => t('Define paths which will NOT require user authentication. Use &lt;front&gt; for front page.'),
      '#default_value' => $config->get('excluded_paths'),
    );
    return parent::buildForm($form, $form_state);
  }

  /**
   * {@inheritdoc}
   */
  public function submitForm(array &$form, FormStateInterface $form_state) {
    $this->config('require_login.config')
      ->set('deny_message', $form_state->getValue('require_login_deny_message'))
      ->set('excluded_paths', $form_state->getValue('require_login_excluded_paths'))
      ->save();

    parent::submitForm($form, $form_state);
  }

}
