# Contributing

Thanks for your interest in contributing!

## Getting Started

This project uses [DDEV](https://ddev.com) with [`ddev-drupal-contrib`](https://github.com/drupal/ddev-drupal-contrib) for local development and testing.

### Requirements

- [DDEV](https://ddev.readthedocs.io/en/stable/)

### Setup

1. Clone the module project:

```sh
git clone https://git.drupalcode.org/project/require_on_publish.git
cd require_on_publish
````

2. Start DDEV and provision Drupal:

```sh
ddev start
ddev poser
```

> `ddev poser` will install Drupal via a transient `composer.contrib.json`,
> configure testing scaffolding, and prepare the site.

3. Symlink your module into the testing site:

```sh
ddev symlink-project
```

> This ensures the module is correctly located in `web/modules/contrib/require_on_publish`.

4. Launch the site:

```sh
ddev launch
```

Install site with:

```sh
ddev drush site:install --account-name=admin --account-pass=admin -y
ddev drush en require_on_publish -y
```

Log in with:

* **Username**: `admin`
* **Password**: `admin`

Or with:

```sh
ddev launch $(ddev drush user:login)
```

## Running Tests

To run all tests:

```sh
ddev phpunit
```

To run a specific test file or method:

```sh
ddev phpunit --filter testIndicators
ddev phpunit tests/src/FunctionalJavascript/EditPageTest.php
```

## Coding Standards

Ensure your code follows the [Drupal Coding Standards](https://www.drupal.org/docs/develop/standards):

```sh
ddev phpcs
```

To auto-fix coding issues:

```sh
ddev phpcbf
```

> Note: if using the Local History VSCode extension, you may wish to include the following:
>
> ```
> <!-- @file phpcs.xml.dist -->
> <exclude-pattern>.history</exclude-pattern>
> ```

## Running Drupal 10 or 11

Easily switch core version with:

```sh
ddev core-version ^10
ddev core-version ^11
```

## Getting Help

Need help? Drop a comment in the [issue queue](https://www.drupal.org/project/issues/require_on_publish).
