(($, Drupal) => {
  $(document)
    // Required on Publish
    // @see https://git.drupalcode.org/project/conditional_fields/-/blob/4.x/js/conditional_fields.js?ref_type=heads#L120
    .on('state:require_on_publish', (e) => {
      if (e.trigger) {
        const legends = $(e.target).find('legend');
        const legendSpan = $(e.target).find('legend span');
        const labels = $(e.target).find(
          ':not(.form-item--editor-format, .form-type-radio)>label',
        );
        const tabs = $('.vertical-tabs');
        let tab = '';
        if (tabs.length !== 0) {
          const detail = $(legends).closest('details');
          const selector = `a[href='#${detail.attr('id')}']`;
          tab = $(selector);
        }
        // eslint-disable-next-line no-lonely-if
        if (e.value) {
          if (legends.length !== 0) {
            legends.addClass('form-required-on-publish');
            legendSpan.addClass('form-required-on-publish');
            if (tabs.length !== 0) {
              tab.find('strong').addClass('form-required-on-publish');
            }
          } else {
            labels.addClass('form-required-on-publish');
          }
        } else {
          // eslint-disable-next-line no-lonely-if
          if (legends.length !== 0) {
            legends.removeClass('form-required-on-publish');
            legendSpan.removeClass('form-required-on-publish');
            if (tabs.length !== 0) {
              tab.find('strong').removeClass('form-required-on-publish');
            }
          } else {
            labels.removeClass('form-required-on-publish');
          }
        }
      }
    });
})(jQuery, Drupal);
