# Require Revision - 1.0.0

A Drupal module that allows administrators to configure which entity types require revisions and revision log messages when editing content.

## Description

The Require Revision module provides a centralized configuration interface for managing revision requirements across multiple entity types in Drupal. Administrators can specify which block types, content types, and taxonomy vocabularies must create new revisions when edited, and optionally require revision log messages for those entities.

## Features

- Configure revision requirements for:
  - Block Types (Custom Blocks)
  - Content Types (Nodes)
  - Taxonomy Vocabularies (Terms)
- Require revision log messages for specific entity types
- "Select all" functionality for quick configuration
- Conditional field behavior - revision log options only available when revision is required
- Automatic enforcement on entity edit forms
- Clean, organized settings interface with collapsible sections

## Requirements

- Drupal 10 or 11
- Node module (part of Drupal core)
- Taxonomy module (part of Drupal core)
- Custom Block (block_content) module (part of Drupal core)

## Installation

1. Download and extract the module to your `modules/custom/` directory
2. Enable the module:
   ```bash
   drush en require_revision
   ```
3. Clear the cache:
   ```bash
   drush cr
   ```

## Configuration

1. Navigate to **Configuration > Content authoring > Require Revision** (`/admin/config/content/require_revision`)
2. Grant the "Administer Require Revision settings" permission to appropriate roles
3. For each entity type section (Block Types, Content Types, Taxonomy Vocabularies):
   - Check the "Select all" box to require revisions for all types, or select individual types
   - Optionally check revision log message requirements for specific types
4. Save the configuration

## Usage

### Settings Page

The settings page is organized into three collapsible sections:

- **Block Types**: Configure revision requirements for custom block types
- **Content Types**: Configure revision requirements for node content types
- **Taxonomy Vocabularies**: Configure revision requirements for taxonomy terms

### "Select All" Functionality

Each section includes "Select all" checkboxes for both revision requirements and revision log requirements:

- Checking "Select all" for revisions will select all types in that section
- The revision log "Select all" and individual options become available only when revision "Select all" is checked
- Unchecking "Select all" for revisions will uncheck and disable all revision log options

### Individual Checkboxes

- Individual revision log checkboxes are only enabled when their corresponding revision checkbox is checked
- When any individual checkbox is unchecked, the "Select all" for that section automatically unchecks

## How It Works

Once configured, the module automatically:

1. **Form Alteration**: Modifies entity edit forms to:
   - Make the revision checkbox required and checked (disabled from unchecking)
   - Make the revision log message field required (if configured)

2. **Entity Presave**: Ensures a new revision is created when saving entities that require revisions, even if the form is bypassed

## File Structure

```
require_revision/
├── require_revision.info.yml
├── require_revision.routing.yml
├── require_revision.links.menu.yml
├── require_revision.permissions.yml
├── require_revision.libraries.yml
├── require_revision.module
├── js/
│   └── require_revision_settings.js
├── src/
│   └── Form/
│       └── RequireRevisionSettingsForm.php
└── README.md
```

## Permissions

- **Administer Require Revision settings**: Allows users to configure which entity types require revisions

## Uninstalling

To uninstall the module:

```bash
drush pm:uninstall require_revision
```

Note: Configuration settings will be removed upon uninstallation. Make note of your settings if you plan to reinstall later.

## Support

For issues, questions, or feature requests, please contact your Drupal administrator or the module maintainer.

## Creator and Maintainer

* Hak-Lo Chan