# Require Revision

A Drupal module that allows administrators to configure which entity types require revisions and revision log messages when editing content.

## Table of Contents

- [Description](#description)
- [Features](#features)
- [Requirements](#requirements)
- [Installation](#installation)
- [Configuration](#configuration)
- [Usage](#usage)
- [Permissions](#permissions)
- [How It Works](#how-it-works)
- [Uninstalling](#uninstalling)
- [Maintainers](#maintainers)

## Description

The Require Revision module provides a centralized configuration interface for managing revision requirements across multiple entity types in Drupal. Administrators can specify which block types, content types, and taxonomy vocabularies must create new revisions when edited, and optionally require revision log messages for those entities.

This module is particularly useful for:
- Organizations requiring audit trails for content changes
- Sites that need to enforce documentation of content modifications
- Content teams that want to ensure proper version control across different entity types

## Features

- **Multi-Entity Support**: Configure revision requirements for:
  - Block Types (Custom Blocks)
  - Content Types (Nodes)
  - Taxonomy Vocabularies (Terms)
- **Revision Log Messages**: Optionally require revision log messages for specific entity types
- **Bulk Operations**: "Select all" functionality for quick configuration across entity types
- **Smart UI**: Conditional field behavior - revision log options only available when revision is required
- **Automatic Enforcement**: Enforces settings on entity edit forms and during entity saves
- **Clean Interface**: Organized settings page with collapsible sections for each entity type
- **Failsafe Protection**: Ensures revisions are created even when forms are bypassed

## Requirements

- **Drupal**: 10 or 11
- **Drupal Core Modules**:
  - Node module (for content types)
  - Taxonomy module (for taxonomy vocabularies)
  - Custom Block (block_content) module (for block types)

## Installation

### Using Composer (Recommended)

```bash
composer require drupal/require_revision
drush en require_revision
drush cr
```

### Manual Installation

1. Download the module to your `modules/contrib/` directory
2. Enable the module:
   ```bash
   drush en require_revision
   ```
3. Clear the cache:
   ```bash
   drush cr
   ```

## Configuration

### Initial Setup

1. Navigate to **Configuration > Content authoring > Require Revision**
   - Direct URL: `/admin/config/content/require_revision`

2. Grant the "Administer Require Revision settings" permission to appropriate roles at:
   - **People > Permissions** (`/admin/people/permissions`)

### Configuring Entity Types

For each entity type section (Block Types, Content Types, Taxonomy Vocabularies):

1. **Click to expand** the collapsible section for the entity type you want to configure

2. **Select revision requirements**:
   - Check individual entity type checkboxes under "Requiring revisions"
   - OR use the "Select all" checkbox to require revisions for all types in that section

3. **Select revision log requirements** (optional):
   - Check individual entity type checkboxes under "Requiring revision log messages"
   - These options are only available when the corresponding revision requirement is enabled

4. **Save configuration** by clicking the "Save configuration" button at the bottom

## Usage

### Settings Page Interface

The settings page is organized into three collapsible sections:

#### Block Types
Configure revision requirements for custom block types. When enabled, any edits to blocks of the selected types will automatically create new revisions.

#### Content Types
Configure revision requirements for node content types. Affects all nodes of the selected content types.

#### Taxonomy Vocabularies
Configure revision requirements for taxonomy terms. Affects all terms within the selected vocabularies.

### "Select All" Functionality

Each section includes "Select all" checkboxes for convenient bulk configuration:

- **Checking "Select all" for revisions**: Selects all types in that section and enables revision log options
- **Checking "Select all" for revision logs**: Requires log messages for all types (only available when "Select all" for revisions is checked)
- **Unchecking "Select all"**: Automatically unchecks all individual checkboxes and disables revision log options

### Individual Checkbox Behavior

- Individual revision log checkboxes are **only enabled** when their corresponding revision checkbox is checked
- When any individual checkbox is unchecked, the "Select all" checkbox for that section automatically unchecks
- This provides visual feedback about the current state of your configuration

## Permissions

The module provides one permission:

### Administer Require Revision Settings

- **Machine name**: `administer require revision`
- **Description**: Configure which entity types require revisions and revision log messages
- **Access restriction**: This is a trusted role permission
- **Grant to**: Site administrators, content managers, or other trusted roles

## How It Works

### Form Alteration (`hook_form_alter`)

The module modifies entity edit forms to:

1. **Make the revision checkbox**:
   - Checked by default
   - Disabled (cannot be unchecked)
   - Display a message indicating revisions are required

2. **Make the revision log field**:
   - Required (when configured)
   - Display standard HTML5 required field validation

### Entity Presave (`hook_entity_presave`)

As a failsafe, the module also:

1. Ensures a new revision is created when saving entities that require revisions
2. Sets a default revision log message if required but not provided
3. Works even when the form is bypassed (e.g., programmatic entity saves)

### Technical Details

- Uses Drupal's Configuration API for persistent storage
- Implements dependency injection for the EntityTypeManager service
- Leverages Drupal's #states Form API for conditional field visibility
- Includes JavaScript for enhanced "Select all" functionality
- Follows Drupal coding standards and best practices

## Uninstalling

To uninstall the module:

```bash
drush pm:uninstall require_revision
drush cr
```

**Note**: Configuration settings will be automatically removed upon uninstallation. Document your settings before uninstalling if you plan to reinstall later.

## File Structure

```
require_revision/
├── composer.json
├── LICENSE.txt
├── README.md
├── require_revision.info.yml
├── require_revision.module
├── require_revision.routing.yml
├── require_revision.links.menu.yml
├── require_revision.permissions.yml
├── require_revision.libraries.yml
├── js/
│   └── require_revision_settings.js
├── src/
│   └── Form/
│       └── RequireRevisionSettingsForm.php
└── tests/
    └── src/
        └── Functional/
            └── RequireRevisionSettingsFormTest.php
```

## Creator and Maintainer

- **Hak-Lo Chan** - [haklo](https://www.drupal.org/u/haklo)

## Support

- **Issue Queue**: https://www.drupal.org/project/issues/require_revision
- **Source Code**: https://git.drupalcode.org/project/require_revision