/**
 * @file
 * Provides "Select all" functionality for Require Revision settings.
 */

(function ($, Drupal, drupalSettings, once) {

    'use strict';

    /**
     * Behavior for Require Revision settings form.
     */
    Drupal.behaviors.requireRevision = {
        attach: function (context, settings) {
            if (!drupalSettings.requireRevision || !drupalSettings.requireRevision.entityTypes) {
                return;
            }

            var entityTypes = drupalSettings.requireRevision.entityTypes;

            $.each(
                entityTypes, function (entityType, types) {
                    if (types.length === 0) {
                        return;
                    }

                    var selectAllSelector = 'input[name="select_all_' + entityType + '"]';
                    var isSelectAllChanging = false;

                    once('sa-' + entityType, selectAllSelector, context).forEach(
                        function (element) {
                            $(element).on(
                                'change', function () {
                                    var checked = $(this).prop('checked');
                                    isSelectAllChanging = true;

                                    $.each(
                                        types, function (index, typeId) {
                                            $('input[name="revision_required_' + entityType + '[' + typeId + ']"]', context).prop('checked', checked).trigger('change');
                                        }
                                    );

                                    setTimeout(
                                        function () {
                                            $.each(
                                                types, function (index, typeId) {
                                                    var $logCheckbox = $('input[name="revision_log_required_' + entityType + '[' + typeId + ']"]', context);
                                                    if (!$logCheckbox.prop('disabled')) {
                                                        $logCheckbox.prop('checked', checked);
                                                    }
                                                }
                                            );
                                            isSelectAllChanging = false;
                                        }, 100
                                    );
                                }
                            );
                        }
                    );

                    $.each(
                        types, function (index, typeId) {
                            var revisionCheckboxSelector = 'input[name="revision_required_' + entityType + '[' + typeId + ']"]';
                            once('rc-' + entityType + '-' + typeId, revisionCheckboxSelector, context).forEach(
                                function (element) {
                                    $(element).on(
                                        'change', function () {
                                            if (!isSelectAllChanging) {
                                                updateSelectAllState(entityType, types, context);
                                            }
                                        }
                                    );
                                }
                            );
                        }
                    );

                    $.each(
                        types, function (index, typeId) {
                            var logCheckboxSelector = 'input[name="revision_log_required_' + entityType + '[' + typeId + ']"]';
                            once('rlc-' + entityType + '-' + typeId, logCheckboxSelector, context).forEach(
                                function (element) {
                                    $(element).on(
                                        'change', function () {
                                            if (!isSelectAllChanging) {
                                                updateSelectAllState(entityType, types, context);
                                            }
                                        }
                                    );
                                }
                            );
                        }
                    );
                }
            );

            /**
             * Update the "Select all" checkbox state.
             */
            function updateSelectAllState(entityType, types, context)
            {
                var allChecked = true;

                $.each(
                    types, function (i, typeId) {
                        if (!$('input[name="revision_required_' + entityType + '[' + typeId + ']"]', context).prop('checked')) {
                            allChecked = false;
                            return false;
                        }
                    }
                );

                if (allChecked) {
                        $.each(
                            types, function (i, typeId) {
                                var $logCheckbox = $('input[name="revision_log_required_' + entityType + '[' + typeId + ']"]', context);
                                if (!$logCheckbox.prop('disabled') && !$logCheckbox.prop('checked')) {
                                    allChecked = false;
                                    return false;
                                }
                            }
                        );
                }

                $('input[name="select_all_' + entityType + '"]', context).prop('checked', allChecked);
            }
        }
    };

})(jQuery, Drupal, drupalSettings, once);