# Require Revision Log Message Tests

This directory contains comprehensive automated tests for the Require Revision Log Message module.

## Running Tests with DDEV

### Quick Start

```bash
# Run all tests for this module
ddev phpunit

# Run specific test suites
ddev phpunit --testsuite=unit
ddev phpunit --testsuite=kernel
ddev phpunit --testsuite=functional

# Run a specific test file
ddev phpunit tests/src/Functional/RequireRevisionLogMessageTest.php

# Run with verbose output
ddev phpunit --verbose
```

## Test Structure

- **Unit Tests** (`tests/src/Unit/`) - Fast, isolated tests
- **Kernel Tests** (`tests/src/Kernel/`) - Tests with minimal Drupal bootstrap
- **Functional Tests** (`tests/src/Functional/`) - Full browser tests

## Test Coverage

The test suite covers:
- Configuration form functionality
- Revision log requirement enforcement
- New vs existing node behavior
- Permission system (admin and bypass)
- Content type filtering
- Update hooks

