<?php

namespace Drupal\required_api\Plugin\Required;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\required_api\Attribute\Required;

/**
 * Defines a fallback plugin for missing required plugins.
 */
#[Required(
  id: self::ID,
  label: new TranslatableMarkup('Broken/Missing'),
  description: new TranslatableMarkup('A fallback strategy for missing required plugins.'),
)]
class Broken extends RequiredBase {

  public const ID = 'broken';

  /**
   * {@inheritdoc}
   */
  public function isRequired(FieldDefinitionInterface $field, ContentEntityInterface $entity): bool {
    return TRUE;
  }

  /**
   * {@inheritdoc}
   */
  public function requiredFormElement(FieldDefinitionInterface $field): array {
    return [
      '#markup' => $this->t('This required strategy is broken or missing. Please select another one.'),
    ];
  }

}
