<?php

namespace Drupal\required_api\Plugin\Required;

use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\Form\FormStateInterface;
use Drupal\Core\Plugin\PluginBase;
use Drupal\required_api\Plugin\RequiredPluginInterface;
use Symfony\Component\DependencyInjection\ContainerInterface;

/**
 * Base class for RequiredPluginInterface plugins.
 */
abstract class RequiredBase extends PluginBase implements RequiredPluginInterface {

  /**
   * Return a form element to use in form_field_ui_field_instance_edit_form.
   *
   * @param \Drupal\Core\Field\FieldDefinitionInterface $field
   *   A field instance.
   *
   * @return array
   *   Form element to configure the required property.
   */
  public function formElement(FieldDefinitionInterface $field): array {
    $element = $this->requiredFormElement($field);

    return $element + [
      '#prefix' => '<div id="required-ajax-wrapper">',
      '#suffix' => '</div>',
      '#parents' => [
        'third_party_settings',
        'required_api',
        'required_plugin_options',
      ],
    ];
  }

  /**
   * {@inheritdoc}
   */
  public function submitFieldConfigForm(array &$form, FormStateInterface $form_state): void {
  }

  /**
   * {@inheritdoc}
   */
  public function getConfiguration() {
    return $this->configuration;
  }

  /**
   * {@inheritdoc}
   */
  public function setConfiguration(array $configuration) {
    $this->configuration = $configuration;
    return $this;
  }

  /**
   * {@inheritdoc}
   */
  public function defaultConfiguration() {
    return [];
  }

  /**
   * {@inheritdoc}
   */
  public static function create(ContainerInterface $container, array $configuration, $plugin_id, $plugin_definition) {
    return new static(
        $configuration,
        $plugin_id,
        $plugin_definition
    );
  }

}
