<?php

namespace Drupal\required_api;

use Drupal\Core\DependencyInjection\ContainerBuilder;
use Drupal\Core\DependencyInjection\ServiceModifierInterface;
use Drupal\required_api\TypedData\RequiredApiTypedDataManager;

/**
 * Modifies the service container to use the RequiredApiTypedDataManager.
 */
class RequiredApiServiceProvider implements ServiceModifierInterface {

  /**
   * {@inheritdoc}
   */
  public function alter(ContainerBuilder $container) {
    if ($container->hasDefinition('typed_data_manager') && $container->hasDefinition('plugin.manager.required_api.required')) {
      $definition = $container->getDefinition('typed_data_manager');
      $definition->setClass(RequiredApiTypedDataManager::class);
    }
  }

}
