<?php

namespace Drupal\required_api\Annotation;

use Drupal\Component\Annotation\Plugin;
use Drupal\Core\Annotation\Translation;

/**
 * The Required annotation.
 *
 * @see hook_required_api_info_alter()
 *
 * @Annotation
 */
class Required extends Plugin {

  /**
   * The plugin ID.
   */
  public string $id;

  /**
   * The administrative label of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public Translation $label;

  /**
   * The description of the plugin.
   *
   * @ingroup plugin_translatable
   */
  public ?Translation $description = NULL;

}
