<?php

namespace Drupal\required_api\Plugin\Required;

use Drupal\Core\Entity\ContentEntityInterface;
use Drupal\Core\Field\FieldDefinitionInterface;
use Drupal\Core\StringTranslation\TranslatableMarkup;
use Drupal\required_api\Attribute\Required;

/**
 * Default required plugin using core implementation.
 */
#[Required(
  id: self::ID,
  label: new TranslatableMarkup('Core'),
  description: new TranslatableMarkup('Required based on core implementation.'),
)]
class RequiredDefault extends RequiredBase {

  public const ID = 'default';

  /**
   * {@inheritdoc}
   */
  public function isRequired(FieldDefinitionInterface $field, ContentEntityInterface $entity): bool {
    return $field->isRequired();
  }

  /**
   * {@inheritdoc}
   */
  public function requiredFormElement(FieldDefinitionInterface $field): array {
    return [
      '#type' => 'checkbox',
      '#title' => $this->t('Required field'),
      '#default_value' => $field->isRequired(),
      '#weight' => -5,
    ];
  }

}
