<?php

namespace Drupal\required_api\TypedData;

use Drupal\Core\TypedData\TypedDataManager;
use Drupal\Core\TypedData\Validation\ExecutionContextFactory as OldExecutionContextFactory;
use Drupal\Core\Validation\ConstraintValidatorFactory;
use Drupal\Core\Validation\DrupalTranslator;
use Drupal\Core\Validation\ExecutionContextFactory;

/**
 * Provides a typed data manager that returns our overridden RecursiveValidator.
 */
class RequiredApiTypedDataManager extends TypedDataManager {

  /**
   * {@inheritdoc}
   */
  public function getValidator() {
    if (!isset($this->validator)) {
      $translator = new DrupalTranslator();

      // @todo Remove this if statement once the minimum supported Drupal version is 10.3.0.
      // @see https://www.drupal.org/node/3396238
      if (class_exists(OldExecutionContextFactory::class)) {
        $executionContextFactory = new OldExecutionContextFactory($translator);
      }
      else {
        $executionContextFactory = new ExecutionContextFactory($translator);
      }

      $this->validator = new RequiredApiRecursiveValidator(
        $executionContextFactory,
        new ConstraintValidatorFactory($this->classResolver),
        $this
      );
    }

    return $this->validator;
  }

}
