<?php

namespace Drupal\resource_conflict\Event;

/**
 * Defines events dispatched by the Resource Conflict module.
 */
final class ResourceConflictEvents {

  /**
   * Dispatched when a node form is validated.
   */
  public const NODE_VALIDATION = 'resource_conflict.node_validation';

  /**
   * Dispatched for each conflicting node that is detected.
   */
  public const CONFLICT_DETECTED = 'resource_conflict.conflict_detected';

  /**
   * Prevent instantiation.
   */
  private function __construct() {}

}
