<?php

/**
 * @file
 * Hooks provided by the Resource Conflict module.
 */

use Drupal\node\NodeInterface;

/**
 * Act on detected resource conflicts.
 *
 * @param \Drupal\node\NodeInterface $node
 *   The unsaved node that triggered the conflict check.
 * @param \Drupal\node\NodeInterface[] $conflicts
 *   The conflicting nodes keyed by node ID.
 */
function hook_resource_conflict_conflicts_detected(NodeInterface $node, array $conflicts): void {
  // Example: log the number of conflicts that were found.
  \Drupal::logger('my_module')->notice('Found @count conflicts for @title.', [
    '@count' => count($conflicts),
    '@title' => $node->label(),
  ]);
}
