<?php

/**
 * @file
 * Example snippets for the Resource Conflict module.
 */

use Drupal\resource_conflict\Event\ConflictDetectedEvent;
use Drupal\resource_conflict\Event\ResourceConflictEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\Core\Logger\LoggerChannelTrait;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;

/**
 * Example event subscriber reacting to Resource Conflict events.
 */
class ExampleResourceConflictSubscriber implements EventSubscriberInterface {
  use LoggerChannelTrait;

  /**
   * Constructs the subscriber.
   */
  public function __construct(LoggerChannelFactoryInterface $logger_factory) {
    $this->setLoggerFactory($logger_factory);
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      ResourceConflictEvents::CONFLICT_DETECTED => 'handleConflict',
    ];
  }

  /**
   * Logs each conflicting pair.
   */
  public function handleConflict(ConflictDetectedEvent $event): void {
    $this->getLogger('my_module')->warning('Conflict between %a and %b', [
      '%a' => $event->getNode()->label(),
      '%b' => $event->getConflictingNode()->label(),
    ]);
  }

}
