<?php

namespace Drupal\resource_conflict\Event;

use Drupal\node\NodeInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event dispatched when conflicting nodes are detected.
 */
class ConflictDetectedEvent extends Event {

  /**
   * Constructs the event.
   */
  public function __construct(
    protected NodeInterface $node,
    protected NodeInterface $conflictingNode,
  ) {}

  /**
   * Gets the unsaved node being validated.
   */
  public function getNode(): NodeInterface {
    return $this->node;
  }

  /**
   * Gets the node that conflicts with the unsaved node.
   */
  public function getConflictingNode(): NodeInterface {
    return $this->conflictingNode;
  }

}
