<?php

/**
 * @file
 * Example snippets for the Resource Conflict module.
 */

use Drupal\resource_conflict\Event\ResourceConflictEvents;
use Drupal\resource_conflict\Event\ConflictsEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\Core\Logger\LoggerChannelTrait;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;

/**
 * Example event subscriber reacting to Resource Conflict events.
 */
class ExampleResourceConflictSubscriber implements EventSubscriberInterface {
  use LoggerChannelTrait;

  /**
   * Constructs the subscriber.
   */
  public function __construct(LoggerChannelFactoryInterface $logger_factory) {
    $this->setLoggerFactory($logger_factory);
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      ResourceConflictEvents::CONFLICTS_FILTER => 'handleConflict',
    ];
  }

  /**
   * Logs conflicts and can filter them.
   */
  public function handleConflict(ConflictsEvent $event): void {
    $conflicts = $event->getConflicts();
    $this->getLogger('my_module')->warning('Found %count conflicts for %title', [
      '%count' => count($conflicts),
      '%title' => $event->getNode()->label(),
    ]);

    // Example filter: keep only the first detected conflict.
    if (!empty($conflicts)) {
      $first = array_slice($conflicts, 0, 1, TRUE);
      $event->setConflicts($first);
    }
  }

}
