<?php

namespace Drupal\resource_conflict\Event;

use Drupal\node\NodeInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event dispatched when a set of conflicts is detected and can be modified.
 */
class ConflictsEvent extends Event {

  /**
   * Constructs the event.
   *
   * @param \Drupal\node\NodeInterface $node
   *   The unsaved node being validated.
   * @param \Drupal\node\NodeInterface[] $conflicts
   *   The conflicts keyed by node ID.
   */
  public function __construct(
    protected NodeInterface $node,
    protected array $conflicts,
  ) {}

  /**
   * Gets the unsaved node being validated.
   */
  public function getNode(): NodeInterface {
    return $this->node;
  }

  /**
   * Gets the detected conflicts.
   *
   * @return \Drupal\node\NodeInterface[]
   *   Conflicting nodes keyed by node ID.
   */
  public function getConflicts(): array {
    return $this->conflicts;
  }

  /**
   * Replaces the detected conflicts.
   *
   * @param \Drupal\node\NodeInterface[] $conflicts
   *   Conflicting nodes keyed by node ID.
   */
  public function setConflicts(array $conflicts): void {
    $this->conflicts = $conflicts;
  }

}
