<?php

/**
 * @file
 * Example snippets for the Resource Conflict module.
 */

use Drupal\resource_conflict\Event\ResourceConflictEvents;
use Drupal\resource_conflict\Event\ConflictsEvent;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;
use Drupal\Core\Logger\LoggerChannelTrait;
use Drupal\Core\Logger\LoggerChannelFactoryInterface;

/**
 * Example event subscriber reacting to Resource Conflict events.
 */
class ExampleResourceConflictSubscriber implements EventSubscriberInterface {
  use LoggerChannelTrait;

  /**
   * Constructs the subscriber.
   */
  public function __construct(LoggerChannelFactoryInterface $logger_factory) {
    $this->setLoggerFactory($logger_factory);
  }

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      ResourceConflictEvents::CONFLICTS_FILTER => 'handleConflict',
    ];
  }

  /**
   * Logs conflicts and can filter them.
   */
  public function handleConflict(ConflictsEvent $event): void {
    $conflict_ids = $event->getConflictIds();
    $this->getLogger('my_module')->warning('Found %count conflicts for %title', [
      '%count' => count($conflict_ids),
      '%title' => $event->getNode()->label(),
    ]);

    // Example filter: keep only the first detected conflict.
    if (!empty($conflict_ids)) {
      $first_id = array_slice($conflict_ids, 0, 1);
      $event->setConflictIds($first_id);
    }
  }

}
