<?php

namespace Drupal\resource_conflict_test\EventSubscriber;

use Drupal\resource_conflict\Event\ConflictValidationEvent;
use Drupal\resource_conflict\Event\ResourceConflictEvents;
use Symfony\Component\EventDispatcher\EventSubscriberInterface;

/**
 * Captures Resource Conflict events for assertions.
 */
class ResourceConflictTestSubscriber implements EventSubscriberInterface {

  /**
   * Recorded node validation labels.
   *
   * @var string[]
   */
  protected static array $validationEvents = [];

  /**
   * {@inheritdoc}
   */
  public static function getSubscribedEvents(): array {
    return [
      ResourceConflictEvents::CONFLICT_VALIDATION => 'onConflictValidation',
    ];
  }

  /**
   * Reacts to node validation events.
   */
  public function onConflictValidation(ConflictValidationEvent $event): void {
    self::$validationEvents[] = $event->getNode()->label();
  }

  /**
   * Resets captured events.
   */
  public static function reset(): void {
    self::$validationEvents = [];
  }

  /**
   * Returns recorded validation events.
   */
  public static function getValidationEvents(): array {
    return self::$validationEvents;
  }

}
