# Resource Conflict (Drupal 10+)

Resource Conflict provides lightweight conflict detection for nodes that expose
Date range fields, recurring dates powered by the Recurring Dates Field
(`date_recur`) module, or Smart Date (`smart_date`) fields. When an editor tries
to save a node whose configured date spans overlap with an existing entry,
validation errors prevent the save and the conflicting nodes are listed. The
module also validates during entity presave so that programmatic saves receive
an exception instead of silently creating duplicates.

This modern port removes the Rules dependency in favour of a dedicated
conflict manager service and Symfony events that you can subscribe to.

## Requirements

- Node module (core)
- Date range module (core `datetime_range`)
- (optional) Recurring Dates Field module (`date_recur`) 3.8.2 or newer when recurring
  schedules should be checked for conflicts.
- (optional) Smart Date module (`smart_date`)

## Installation

1. Place the module inside your Drupal codebase.
2. Enable **Resource Conflict** from the Extend page or via Drush.

## Configuration

1. Create a Date range, Recurring Dates Field (`date_recur`), or Smart Date
   (`smart_date`) field on the content type that should participate in conflict
   detection.
2. Edit the content type and open **Additional settings → Resource conflict**.
3. Enable the checkbox, choose the Date range, Recurring Dates Field
   (`date_recur`), or Smart Date (`smart_date`) field, and optionally set
   start / end buffer adjustments. Buffers use `strtotime()` syntax (for
   example `-5 minutes` to add padding before the start time).
4. Save the content type configuration.

Repeat the steps for every content type that should be checked. Multiple
content types can share the same Date range, Recurring Dates Field (`date_recur`),
or Smart Date (`smart_date`) field; unless **Restrict conflicts to this content
type** is checked, nodes across those bundles will be compared. You can also
uncheck **Show a default validation error**
if you plan to handle conflicts entirely via subscribers or hooks.

## Runtime behavior

- Node forms run a custom validator that lists all conflicting nodes.
- A presave hook throws an `EntityStorageException` if code attempts to save a
  conflicting node without going through the form layer.
- Conflicts are detected via entity queries against the configured Date range,
  Recurring Dates, or Smart Date (`smart_date`) storage (including generated
  occurrences).
  Buffers are applied before running the query so you can pad events.

## Extending

- Subscribe to the Symfony events exposed by the module:
- `resource_conflict.conflict_validation`
  (`Drupal\resource_conflict\Event\ConflictValidationEvent`) fires whenever a
  Resource Conflict enabled node form validates. Event subscribers can
  inspect the unsaved node and even alter the form before Drupal
  processes errors.
  - `resource_conflict.conflicts_filter`
    (`Drupal\resource_conflict\Event\ConflictsEvent`) fires after conflicts are
    gathered and allows subscribers to inspect or filter the list of node IDs
    before validation errors or presave exceptions are raised. Subscribers can
    load and act on the conflicts as needed.

## Credits

Resource Conflict was originally developed by Andrew Berry
(`andrewberry@sentex.net`) for the Protein Dynamics lab at the University
of Guelph and later rewritten for Rules/Entity integration by Campbell
Vertesi (`campbell@vertesi.com`). This port updates the codebase for
Drupal 10+ and removes the dependency on the Rules module.
