<?php

namespace Drupal\resource_conflict\Event;

use Drupal\Core\Form\FormStateInterface;
use Drupal\node\NodeInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event fired when a Resource Conflict-enabled node form is validated.
 */
class ConflictValidationEvent extends Event {

  /**
   * Constructs the event.
   */
  public function __construct(
    protected NodeInterface $node,
    protected array &$form,
    protected FormStateInterface $formState,
    protected array $conflicts,
  ) {}

  /**
   * The node being validated.
   */
  public function getNode(): NodeInterface {
    return $this->node;
  }

  /**
   * The node form render array.
   */
  public function &getForm(): array {
    return $this->form;
  }

  /**
   * The form state.
   */
  public function getFormState(): FormStateInterface {
    return $this->formState;
  }

  /**
   * The detected conflicts for the node.
   *
   * @return \Drupal\node\NodeInterface[]
   *   Conflicting nodes keyed by node ID.
   */
  public function getConflicts(): array {
    return $this->conflicts;
  }

}
