<?php

namespace Drupal\resource_conflict\Event;

use Drupal\node\NodeInterface;
use Symfony\Contracts\EventDispatcher\Event;

/**
 * Event dispatched when a set of conflicts is detected and can be modified.
 */
class ConflictsEvent extends Event {

  /**
   * Constructs the event.
   *
   * @param \Drupal\node\NodeInterface $node
   *   The unsaved node being validated.
   * @param int[] $conflictIds
   *   The conflicts keyed by node ID.
   */
  public function __construct(
    protected NodeInterface $node,
    protected array $conflictIds,
  ) {}

  /**
   * Gets the unsaved node being validated.
   */
  public function getNode(): NodeInterface {
    return $this->node;
  }

  /**
   * Gets the detected conflict IDs.
   *
   * @return int[]
   *   Conflicting node IDs.
   */
  public function getConflictIds(): array {
    return $this->conflictIds;
  }

  /**
   * Replaces the detected conflict IDs.
   *
   * @param int[] $conflictIds
   *   Conflicting node IDs.
   */
  public function setConflictIds(array $conflictIds): void {
    $this->conflictIds = $conflictIds;
  }

}
