<?php

namespace Drupal\resource_conflict\Event;

/**
 * Defines events dispatched by the Resource Conflict module.
 */
final class ResourceConflictEvents {

  /**
   * Dispatched when a node form is validated.
   */
  public const string CONFLICT_VALIDATION = 'resource_conflict.conflict_validation';

  /**
   * Dispatched after conflicts are gathered to allow filtering.
   */
  public const string CONFLICTS_FILTER = 'resource_conflict.conflicts_filter';

  /**
   * Prevent instantiation.
   */
  private function __construct() {}

}
