# Responsive favicons

## Introduction

Responsive Favicons module adds the favicons generated by [realfavicongenerator.net](https://realfavicongenerator.net/) to
your site. The responsive name comes from the fact that many devices are
catered for including iPhone, Android, iPad, other tablets and desktops.

This module can prove to be really useful in Drupal multisite setups where you
do not want to pollute the base of the docroot with loads of icons that pertain
to only a single site. This module allows you to store per site variations of
the icons, in each site's respective public files directory.


## Requirements

* Drupal 10.3+ or Drupal 11+
* Favicon files generated by http://realfavicongenerator.net/
* HTML code generated by http://realfavicongenerator.net/


## Installation and configuration

1. Generate the favicons and the HTML code on http://realfavicongenerator.net/

   You will need a SVG file already created.
   Smaller files can be uploaded but these will produce inferior results.

   When asked for the "path" in realfavicongenerator.net select "I will place
   favicon files (favicon.ico, apple-touch-icon.png, etc.) at the root of my web
   site. Recommended." - this is because Drupal will rewrite the URLs based on
   your configuration of the module for you.

2. Install Responsive Favicons module as you install a contributed Drupal
   module.
   See https://www.drupal.org/docs/extending-drupal/installing-modules

3. Go to /admin/config/user-interface/responsive_favicons to configure the
   module.

   Here you will need to paste in the HTML provided by realfavicongenerator.net
   and upload the zip file they provided you with.

4. This module will take over the following common paths if the corresponding
   files exist:

   * `/favicon.ico`
   * `/favicon.svg`
   * `/apple-touch-icon.png`
   * `/apple-touch-icon-precomposed.png`
   * `/site.webmanifest`
   * `/browserconfig.xml` _(deprecated)_

   To ensure that the `/favicon.ico` path is properly handled by the module, you
   must comment out the following line in the Drupal `.htaccess` file:

   ```
   # RewriteCond %{REQUEST_URI} !=/favicon.ico
   ```

   Your site will now output the required metadata for the favicons to work. You
   can always check the status report page to find out if your site has been
   correctly configured.

   **N.B.** The 'favicon' module duplicates some functionality of responsive
   favicons, so it is preferred that you only install one of the two modules.


## Further reading

This entire module was spawned from a blog post on the topic located at
https://www.pixelite.co.nz/article/adding-apple-android-favicons-drupal/
