<?php

namespace Drupal\responsive_layout_builder\Ajax;

use Drupal\Core\Ajax\CommandInterface;

/**
 * Class RlbTriggerLoadedEvent.
 */
class RlbTriggerLoadedEvent implements CommandInterface {

  protected $component_uuid;

  public function __construct($component_uuid) {
    $this->component_uuid = $component_uuid;
  }

  /**
   * Render the ajax command.
   *
   * @return ajax
   *   Command function.
   */
  public function render() {
    return [
      'command' => 'rlbTriggerLoadedEvent',
      'component_uuid' => $this->component_uuid,
    ];
  }
}
