<?php

namespace Drupal\responsive_slideshow\Plugin\Block;

use Drupal\Core\Block\BlockBase;

/**
 * Provides responsive_slideshow block.
 *
 * @Block(
 *   id = "responsive_slideshow",
 *   admin_label = @Translation("Responsive Slideshow"),
 *   category = @Translation("Blocks")
 * )
 */
class SlideshowBlock extends BlockBase {

  /**
   * {@inheritdoc}
   */
  public function build() {
    $sliders = responsive_slideshow_homepage();
    return [
      '#theme' => 'slideshow_data',
      '#data' => $sliders,
      '#attached' => [
        'library' => [
          'responsive_slideshow/responsive-styling',
        ],
      ],
      '#cache' => [
        'max-age' => 0,
      ],
    ];
  }

}
