/**
 * @file
 * Customizations to original Tablesaw library.
 */

(function (Drupal) {

  'use strict';

  Drupal.responsive_tables_filter = Drupal.responsive_tables_filter || {};
  Drupal.behaviors.responsiveTablesAccessibility = {
    attach: function (context) {
      if (window.Tablesaw !== 'undefined') {
        if (once('tablesaw-create', 'html').length) {
          window.addEventListener(Tablesaw.events.create, function (event) {
            Drupal.responsive_tables_filter.fixCellLabels(context);
          });
        }
      }
    }
  };

  /**
   * Find all Tablesaw-generated cell labels.
   */
  Drupal.responsive_tables_filter.fixCellLabels = function (context) {
    var labels = document.querySelectorAll('b.tablesaw-cell-label');
    labels.forEach(function (label) {
      Drupal.responsive_tables_filter.makeElementAccessible(label);
    });
  };

  /**
   * Replace all Tablesaw-generated b elements with strong.
   */
  Drupal.responsive_tables_filter.makeElementAccessible = function (label) {
    var replacement = document.createElement('strong');
    replacement.innerHTML = label.innerHTML;
    if (label.hasAttribute('class')) {
      replacement.setAttribute('class', label.getAttribute('class'));
    }
    replacement.setAttribute('aria-hidden', 'true');
    label.parentNode.replaceChild(replacement, label);
  };

})(Drupal);
