<?php

declare(strict_types=1);

namespace Drupal\Tests\responsive_tables_filter\Functional;

/**
 * Tests whether a missing thead element skips adding tablesaw classes.
 *
 * @group responsive_tables_filter
 */
class StackTest extends TestBase {

  /**
   * {@inheritdoc}
   */
  protected $mode = 'stack';

  /**
   * Input & output for stack mode.
   *
   * @var data
   */
  private static $data = [
    '<table class="table tablesaw"><thead><tr><th>Name</th><th>Rank</th></tr></thead><tbody><tr><td>Alpha</td><td>1</td></tr><tr><td>Beta</td><td>2</td></tr></tbody></table>' => '<table class="table tablesaw tablesaw tablesaw-stack" data-tablesaw-mode="stack" data-tablesaw-minimap><thead><tr><th role="columnheader" data-tablesaw-priority="persist">Name</th><th role="columnheader">Rank</th></tr></thead><tbody><tr><td>Alpha</td><td>1</td></tr><tr><td>Beta</td><td>2</td></tr></tbody></table>',
    '<table class="table tablesaw tablesaw-columntoggle" data-tablesaw-sortable=""><thead><tr><th data-tablesaw-sortable-default-col="">Name</th><th>Rank</th></tr></thead><tbody><tr><td>Alpha</td><td>1</td></tr><tr><td>Beta</td><td>2</td></tr></tbody></table>' => '<table class="table tablesaw tablesaw-columntoggle tablesaw tablesaw-columntoggle" data-tablesaw-mode="columntoggle" data-tablesaw-minimap><thead><tr><th role="columnheader" data-tablesaw-sortable-col data-tablesaw-priority="1">Name</th><th role="columnheader" data-tablesaw-sortable-col data-tablesaw-priority="2">Rank</th></tr></thead><tbody><tr><td>Alpha</td><td>1</td></tr><tr><td>Beta</td><td>2</td></tr></tbody></table>',
    '<table class="test missing thead"></table>' => '<table class="test missing thead"></table>',
  ];

  /**
   * Tests the responsive_tables_filter Stack (default) mode.
   */
  public function testThead() {
    $page = $this->getSession()->getPage();
    foreach (self::$data as $input => $expected) {
      $settings = [];
      $settings['type'] = 'page';
      $settings['title'] = 'Test Missing Thead';
      $settings['body'] = [
        'value' => $input,
        'format' => 'custom_format',
      ];
      $node = $this->drupalCreateNode($settings);
      $this->drupalGet('node/' . $node->id());
      $table = $page->find('css', 'table');
      $this->assertEquals($expected, str_replace('=""', '', $table->getOuterHtml()));
    }
  }

}
