# REST Easy
Developing a custom API within Drupal can be a cluttered process, requiring
separate files for auth plugins, controllers, endpoint routes, OpenAPI
documentation, and more. REST Easy simplifies the process by defining base
classes for APIs, endpoints, and parameters that provide sensible defaults and
unify many of the moving parts under simple plugin attributes.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/rest_easy).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/rest_easy).

## Requirements
This module requires no modules outside of Drupal core.

## Recommended modules
Enable the [OpenAPI](https://www.drupal.org/project/openapi) and REST Easy 
OpenAPI Integration modules to automatically generates OpenAPI documentation for
your APIs. Enable the REST Easy Postman module to generate downloadable Postman
collections for your APIs.

## Installation
This module is intended to accelerate and simplify API development. It should
only be installed if listed as a dependency for another module or as an aid to
custom API development.

Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration
This module requires no configuration.

## Maintainers (optional)
- Stephen Ward - [stephenward](https://www.drupal.org/u/stephenward)
