# REST Easy API Keys
This module provides a simple user-based API key authentication plugin to use as
part of a REST Easy-based API.

For a full description of the module, visit the
[project page](https://www.drupal.org/project/rest_easy).

Submit bug reports and feature suggestions, or track changes in the
[issue queue](https://www.drupal.org/project/issues/rest_easy).

## Table of contents
- Requirements
- Installation
- Configuration
- Maintainers

## Requirements
This module requires the [REST Easy](https://www.drupal.org/project/rest_easy)
module.

## Installation
Install as you would normally install a contributed Drupal module. For further
information, see [Installing Drupal Modules](https://www.drupal.org/docs/extending-drupal/installing-drupal-modules).

## Configuration
After installation, you will find an API Keys tab on user profiles. This tab is
available to any user with the "Manage REST Easy API keys" permission and
permission to update the given user profile. Click over to this tab to manage
the list of API keys associated with each account. You can click the link at the
bottom of the page to quickly add a random UUID as a new API key.

When building REST Easy API or endpoint plugins, you can include
"rest_easy_api_key" in the plugin's "auth" attribute, like so:

```
#[RESTEasyAPI(
  ...
  auth: ["cookie", "rest_easy_api_key"],
  ...
)]
```

Doing so will authenticate the affected endpoints as the user associated with
the API key used. It will also update your API's OpenAPI documentation with an
Authorize option that accepts either an X-API-Key header or an apiKey query
parameter.

## Maintainers
- Stephen Ward - [stephenward](https://www.drupal.org/u/stephenward)
